#define _XOPEN_SOURCE 600
#include "common.h"

real_t
    *b_vec    = NULL,
    *ad_vec   = NULL,
    *d_vec[2] = { NULL, NULL },
    *r_vec[2] = { NULL, NULL },
    *x_vec[2] = { NULL, NULL };
#define B(i)  b_vec[(i)]
#define AD(i) ad_vec[(i)]
#define D(i)  d_vec[0][(i)]
#define Dp(i) d_vec[1][(i)]
#define R(i)  r_vec[0][(i)]
#define Rp(i) r_vec[1][(i)]
#define X(i)  x_vec[0][(i)]
#define Xp(i) x_vec[1][(i)]


int
main ( int argc, char **argv )
{
    int_t max_iteration;
    if ( argc > 1 )
    {
        int_t factor = strtol ( argv[1], NULL, 10 );
        max_iteration = factor * N;
    }
    else
        max_iteration = N;

    full_matrix = malloc ( N * N * sizeof(real_t) );

    b_vec    = malloc ( N * sizeof(real_t) );
    ad_vec   = malloc ( N * sizeof(real_t) );
    d_vec[0] = malloc ( N * sizeof(real_t) );
    d_vec[1] = malloc ( N * sizeof(real_t) );
    r_vec[0] = malloc ( N * sizeof(real_t) );
    r_vec[1] = malloc ( N * sizeof(real_t) );
    x_vec[0] = malloc ( N * sizeof(real_t) );
    x_vec[1] = malloc ( N * sizeof(real_t) );

    FILE *input;
    input = fopen ( "ex3.dat", "r" );
    fread ( full_matrix, sizeof(real_t), N*N, input );
    fclose ( input );
    input = fopen ( "b.dat", "r" );
    fread ( b_vec, sizeof(real_t), N, input );
    fclose ( input );

    /* Guess first x randomly */
    struct timeval t;
    gettimeofday ( &t, NULL );
    srand ( t.tv_usec );
    for ( int_t i=0; i<N; i++ )
        X(i) = (rand() / (real_t)RAND_MAX);

    /* Initialize: d0 = r0 = b - Ax */
    for ( int_t i=0; i<N; i++ )
    {
        real_t ax = 0.0;
        for ( int_t j=0; j<N; j++ )
            ax += A(i,j) * X(j);
        D(i) = R(i) = B(i) - ax;
    }

    /* Iterate for as many times as requested */
    for ( int_t iter=1; iter<=max_iteration; iter++ )
    {
        printf ( "Iteration %ld of %ld\n", iter, max_iteration );

        // Get the dot product of the residual with itself
        real_t r_square = 0.0;
        for ( int_t i=0; i<N; i++ )
            r_square += R(i)*R(i);

        // Rotate the search direction
        for ( int_t i=0; i<N; i++ )
        {
            AD(i) = 0.0;
            for ( int_t j=0; j<N; j++ )
                AD(i) += A(i,j) * D(j);
        }

        real_t dAD = 0.0; // Intermediate value: d times AD
        for ( int_t i=0; i<N; i++ )
            dAD += D(i) * AD(i);
        real_t alpha = r_square / dAD;

        // Get new x vector
        for ( int_t i=0; i<N; i++ )
            Xp(i) = X(i) + alpha * D(i);

        // Find residual in new direction
        for ( int_t i=0; i<N; i++ )
            Rp(i) = R(i) - alpha * AD(i);

        // Square the new residual too
        real_t rp_square = 0.0;
        for ( int_t i=0; i<N; i++ )
            rp_square += Rp(i)*Rp(i);
        real_t beta = rp_square / r_square;

        // Make a step 
        for ( int_t i=0; i<N; i++ )
            Dp(i) = Rp(i) + beta * D(i);

        // Swap old and updated vectors, and do everything all over again
        real_t *tmp;
        tmp = d_vec[0];
        d_vec[0] = d_vec[1];
        d_vec[1] = tmp;

        tmp = r_vec[0];
        r_vec[0] = r_vec[1];
        r_vec[1] = tmp;

        tmp = x_vec[0];
        x_vec[0] = x_vec[1];
        x_vec[1] = tmp;
    }

    /* Save the result */
    FILE *out = fopen ( "x.dat", "wb" );
    fwrite ( x_vec[0], sizeof(real_t), N, out );
    fclose ( out );

    /* Clean up, go home */
    free ( full_matrix );
    free ( b_vec    );
    free ( ad_vec   );
    free ( d_vec[0] );
    free ( d_vec[1] );
    free ( r_vec[0] );
    free ( r_vec[1] );
    free ( x_vec[0] );
    free ( x_vec[1] );
    exit ( EXIT_SUCCESS );
}
