#include "common.h"


int
main ()
{
    /* Make space for the matrix, and open the file with the numbers in */
    full_matrix = malloc ( N * N * sizeof(real_t) );
    FILE *input = fopen ( "coordinates.txt", "r" );
    int_t line = 1;

    /* Read all of the values, and put each in two places (ex3 is symmetric) */
    for ( int_t l=0; l<NNZ; l++ )
    {
        int_t i, j;
        real_t v;
        int elements = fscanf ( input, "%ld %ld %lf\n", &i, &j, &v );
        if ( elements != 3 )
        {
            fprintf ( stderr, "Error reading line %ld\n", line );
            exit ( EXIT_FAILURE );
        }

        // Coordinates in the file are indexed from 1.
        // Also, take care of the symmetry thing:
        A(i-1,j-1) = A(j-1,i-1) = v;

        line = line + 1;
    }
    fclose ( input );

    /* Write the whole thing as binary data, with zeroes and everything */
    FILE *output = fopen ( "ex3.dat", "wb" );
    for ( int_t i=0; i<N; i++ )
        for ( int_t j=0; j<N; j++ )
            fwrite ( &A(i,j), sizeof(real_t), 1, output );
    fclose ( output );
    free ( full_matrix );
    exit ( EXIT_SUCCESS );
}
