#include "common.h"


int
main ()
{
    /* Allocate space for the matrix, and load it from file */
    full_matrix = malloc ( N * N * sizeof(real_t) );
    FILE *input = fopen ( "ex3.dat", "r" );
    fread ( full_matrix, sizeof(real_t), N*N, input );
    fclose ( input );

    /* Open another file, and store the sums of all the rows in it.
     * This will be our b-vector, and then x = [1,1,1,1,1,...,1] solves Ax=b
     */
    FILE *output = fopen ( "b.dat", "wb" );
    for ( int_t i=0; i<N; i++ )
    {
        real_t sum = 0.0;
        for ( int_t j=0; j<N; j++ )
            sum += A(i,j);
        fwrite ( &sum, sizeof(real_t), 1, output );
    }
    fclose ( output );

    free ( full_matrix );
    exit ( EXIT_SUCCESS );
}
