#define _XOPEN_SOURCE 600
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <tgmath.h>

typedef complex double complex_t;
typedef double real_t;
typedef int64_t int_t;

const int_t
    N = (1<<17);


void
recursive_dft ( int_t N, complex_t * input, complex_t *output )
{
    if (N == 1) {
        output[0] = input[0];
        return;
    }

    complex_t *even = (complex_t *) malloc ( sizeof(complex_t) * N );
    complex_t *odd  = (complex_t *) malloc ( sizeof(complex_t) * N );

    complex_t *even_tmp = (complex_t *) malloc ( sizeof (complex_t) * N/2 );
    complex_t *odd_tmp  = (complex_t *) malloc ( sizeof (complex_t) * N/2 );
    for ( int_t k = 0; k < N/2; k++ )
    {
        even_tmp[k] = input[2*k];
        odd_tmp[k]  = input[2*k + 1];
    }
    recursive_dft ( N/2, even_tmp, even );
    recursive_dft ( N/2, odd_tmp,  odd  );
    free ( even_tmp );
    free ( odd_tmp  );

    for ( int_t k = 0; k < N/2; k++ )
        odd[k] *= exp ( -2.0 * M_PI * I * k / (real_t)N );

    for ( int_t k = 0; k < N/2; k++)
    {
        output[k]       = even[k] + odd[k];
        output[k + N/2] = even[k] - odd[k];
    }
    free(even);
    free(odd);
}


int
main ( int argc, char **argv )
{
    complex_t *input  = malloc ( N * sizeof(complex_t) );
    complex_t *output = malloc ( N * sizeof(complex_t) );

    FILE *in = fopen ( "wave.dat", "r" );
    for ( int_t n=0; n<N; n++ )
    {
        real_t r;
        fread ( &r, sizeof(real_t), 1, in );
        input[n] = r + I*0.0;
    }
    fclose ( in );

    recursive_dft ( N, input, output );

    FILE *out;
    out = fopen ( "real.dat", "wb" );
    for ( int_t n=0; n<N; n++ )
    {
        real_t value = creal ( output[n] );
        fwrite ( &value, sizeof(real_t), 1, out );
    }
    fclose ( out );
    out = fopen ( "imag.dat", "wb" );
    for ( int_t n=0; n<N; n++ )
    {
        real_t value = cimag ( output[n] );
        fwrite ( &value, sizeof(real_t), 1, out );
    }
    fclose ( out );

    free ( input );
    free ( output );
    exit ( EXIT_SUCCESS );
}
