#define _XOPEN_SOURCE 600
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>
#include <unistd.h>

typedef double real_t;
typedef uint64_t int_t;

const int_t
    N = (1<<17);
const real_t
    periods = 3.0;
real_t
    frequency[3] = { 110.0, 277.18, 659.25 };

int
main ( int argc, char **argv )
{
    printf ( "%ld\n", N );
    FILE *signal = fopen ( "wave.dat", "wb" );
    for ( int_t t=0; t<N; t++ ) 
   {
        real_t value = (1/3.0) * (
            sin ( frequency[0]*periods*2.0*M_PI*t / (real_t) N )
          + cos ( frequency[1]*periods*2.0*M_PI*t / (real_t) N )
          + sin ( frequency[2]*periods*2.0*M_PI*t / (real_t) N )
        );
        fwrite ( &value, sizeof(real_t), 1, signal );
    }
    fclose ( signal );

    exit ( EXIT_SUCCESS );
}
