#define _XOPEN_SOURCE 600
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>
#include <unistd.h>

typedef double real_t;
typedef uint64_t int_t;

const int_t
    N = (1<<17);
const real_t
    periods = 3.0;
real_t
    frequency = 1.0;

void options ( int argc, char **argv );


int
main ( int argc, char **argv )
{
    printf ( "%ld\n", N );
    options ( argc, argv );
    FILE *signal = fopen ( "wave.dat", "wb" );
    for ( int_t t=0; t<N; t++ ) 
    {
        real_t value = sin ( frequency*periods*2.0*M_PI*t / (real_t) N );
        fwrite ( &value, sizeof(real_t), 1, signal );
    }
    fclose ( signal );

    exit ( EXIT_SUCCESS );
}


void
options ( int argc, char **argv )
{
    int o;
    while ( (o = getopt ( argc, argv, "f:" )) != -1 )
    {
        switch ( o )
        {
            case 'f':
                frequency = strtod ( optarg, NULL );
                break;
        }
    }
}
