#define _XOPEN_SOURCE 600
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <tgmath.h>
#include <unistd.h>

#include <fftw3.h>

typedef double real_t;
typedef double complex complex_t;
typedef uint64_t int_t;

const int_t
    N = (1<<17);


int
main ( int argc, char **argv )
{
    printf ( "%ld\n", N );
    complex_t
        *transform = malloc ( N * sizeof(complex_t) ),
        *signal = malloc ( N * sizeof(complex_t) );

    /* Read the transformed values from its two components, and
     *  convert to complex numbers in memory */
    FILE *real = fopen ( "real.dat", "r" );
    FILE *imag = fopen ( "imag.dat", "r" );
    for ( int_t k=0; k<N; k++ )
    {
        double re, im;
        fread ( &re, sizeof(real_t), 1, real );
        fread ( &im, sizeof(real_t), 1, imag );
        transform[k] = re + I*im;
    }
    fclose ( real );
    fclose ( imag );

    /* Use FFTW3 library for inverse transform */
    fftw_plan plan = fftw_plan_dft_1d (
        N, transform, signal, FFTW_BACKWARD, FFTW_ESTIMATE
    );
    fftw_execute ( plan );
    fftw_destroy_plan ( plan );

    /* Write the signal back in 'recover.dat' */
    FILE *inverted = fopen ( "recover.dat", "wb" );
    for ( int_t k=0; k<N; k++ )
    {
        double re;
        re = ( 1.0 / (real_t)N ) * creal ( signal[k] );
        fwrite ( &re, 1, sizeof(real_t), inverted );
    }
    fclose ( inverted );

    free ( transform );
    free ( signal );
    exit ( EXIT_SUCCESS );
}
