#define _XOPEN_SOURCE 600
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <tgmath.h>

typedef complex double complex_t;
typedef double real_t;
typedef int64_t int_t;

const int_t
    N = (1<<17);


int
main ( int argc, char **argv )
{
    complex_t *input  = malloc ( N * sizeof(complex_t) );
    complex_t *output = malloc ( N * sizeof(complex_t) );

    FILE *in = fopen ( "wave.dat", "r" );
    for ( int_t n=0; n<N; n++ )
    {
        real_t r;
        fread ( &r, sizeof(real_t), 1, in );
        input[n] = r + I*0.0;
    }
    fclose ( in );

    for ( int_t k=0; k<N; k++ )
    {
        output[k] = 0.0 + I*0.0;
        for ( int_t n=0; n<N; n++ )
            output[k] += input[n] * exp (-2.0 * M_PI * I * n * k / (real_t) N);
        if ( k % 4096 == 0 )
            printf ( "%ld\n", k );
    }

    FILE *out;
    out = fopen ( "real.dat", "wb" );
    for ( int_t n=0; n<N; n++ )
    {
        real_t value = creal ( output[n] );
        fwrite ( &value, sizeof(real_t), 1, out );
    }
    fclose ( out );
    out = fopen ( "imag.dat", "wb" );
    for ( int_t n=0; n<N; n++ )
    {
        real_t value = cimag ( output[n] );
        fwrite ( &value, sizeof(real_t), 1, out );
    }
    fclose ( out );

    free ( input );
    free ( output );

    exit ( EXIT_SUCCESS );
}
