#define _XOPEN_SOURCE 600
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <tgmath.h>
#include <unistd.h>

#include <fftw3.h>

typedef double real_t;
typedef double complex complex_t;
typedef uint64_t int_t;

const int_t
    N = (1<<17);


int
main ( int argc, char **argv )
{
    printf ( "%ld\n", N );
    complex_t
        *transform = malloc ( N * sizeof(complex_t) );

    /* Read the transformed values from its two components, and
     *  convert to complex numbers in memory */
    FILE *real = fopen ( "real.dat", "r" );
    FILE *imag = fopen ( "imag.dat", "r" );
    for ( int_t k=0; k<N; k++ )
    {
        double re, im;
        fread ( &re, sizeof(real_t), 1, real );
        fread ( &im, sizeof(real_t), 1, imag );
        transform[k] = re + I*im;
    }
    fclose ( real );
    fclose ( imag );

    /* Move frequencies between 250 and 300 Hz down by 15.55 */
    /* 3x gives 750-900 */
    /* 15.55 shift corresponds to 46.65, so let's call it dk=-47 */
    for ( int kk=750; kk<900; kk++ )
    {
        transform[kk] = transform[kk+47];
        transform[131072-kk] = transform[131072-kk-47];
    }

    /* Write the signal back */
    real = fopen ( "real.dat", "wb" );
    imag = fopen ( "imag.dat", "wb" );
    for ( int_t k=0; k<N; k++ )
    {
        double re, im;
        re = creal ( transform[k] );
        im = cimag ( transform[k] );
        fwrite ( &re, sizeof(real_t), 1, real );
        fwrite ( &im, sizeof(real_t), 1, imag );
    }
    fclose ( real );
    fclose ( imag );

    free ( transform );
    exit ( EXIT_SUCCESS );
}
