#define _XOPEN_SOURCE 600
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <tgmath.h>

typedef complex double complex_t;
typedef double real_t;
typedef int64_t int_t;

const int_t
    N = (1<<17);


int
main ( int argc, char **argv )
{
    real_t *input = malloc ( N * sizeof(real_t) );

    FILE *in = fopen ( "wave.dat", "r" );
    fread ( input, sizeof(real_t), N, in );
    fclose ( in );

    uint32_t lword;
    uint16_t word;
    // Write header for mono wave at 44100 samples per second
    FILE *out = fopen ( "sound.wav", "wb" );
    fprintf ( out, "RIFF" );
    lword = 36; fwrite ( &lword, sizeof(uint32_t), 1, out );    // header size
    fprintf ( out, "WAVEfmt " );
    lword = 16;    fwrite ( &lword, sizeof(uint32_t), 1, out ); // subchunk size
    word = 1;      fwrite ( &word,  sizeof(uint16_t), 1, out ); // PCM format
    word = 1;      fwrite ( &word,  sizeof(uint16_t), 1, out ); // Mono
    lword = 44100; fwrite ( &lword, sizeof(uint32_t), 1, out ); // 44100 Hz
    lword = 88200; fwrite ( &lword, sizeof(uint32_t), 1, out ); // Byterate
    word = 2;      fwrite ( &word,  sizeof(uint16_t), 1, out ); // Block align
    word = 16;     fwrite ( &word,  sizeof(uint16_t), 1, out ); // 2byte sample
    fprintf ( out, "data" );
    lword = N*2;   fwrite ( &lword, sizeof(uint32_t), 1, out ); // Data size

    for ( int_t n=0; n<N; n++ )
    {
        word = floor ( 32767.0 * input[n] );
        fwrite ( &word, sizeof(uint16_t), 1, out );
    }

    fclose ( out );

    exit ( EXIT_SUCCESS );
}
