#include "common.h"
real_t
    *x_vec       = NULL,
    *b_vec       = NULL;

#define X(i)  x_vec[(i)]
#define B(i)  b_vec[(i)]

int
main ()
{
    /* Allocate stuff for the matrix, two x-vectors (old/new), and b */
    full_matrix = malloc ( N * N * sizeof(real_t) );
    x_vec       = malloc ( N * sizeof(real_t) );
    b_vec       = malloc ( N * sizeof(real_t) );

    /* Load the matrix */
    FILE *input = fopen ( "ex3.dat", "r" );
    fread ( full_matrix, sizeof(real_t), N*N, input );
    fclose ( input );

    /* Load the right hand side vector */
    input = fopen ( "b.dat", "r" );
    fread ( b_vec, sizeof(real_t), N, input );
    fclose ( input );

    /* Initialize the left hand side vector (x) arbitrarily */
    struct timeval now;
    gettimeofday ( &now, NULL );
    srand ( now.tv_usec );
    for ( int_t i=0; i<N; i++ )
        X(i) = rand() / (real_t) RAND_MAX;

    /* Run Jacobi iterations until x is close enough */
    int_t iterations = 0;

    int_t update_row = 0;       // Where was the biggest update this time?
    real_t
        max_update,             // What's the biggest update this time?
        threshold = 5e-8;       // Stop when it's smaller than this

    /* This is the solver loop */
    do {
        max_update = 0.0;        // New iteration, new updates to make

        for ( int_t i=0; i<N; i++ )
        {
            // Here's the Jacobi formula again, but we're writing the updated
            //  values right back in x instead of having one new x and one old
            real_t sigma = 0.0;
            for ( int_t j=0; j<N; j++ )
                if ( j != i )
                    sigma = sigma + A(i,j) * X(j);
            real_t x_before = X(i);
            X(i) = (B(i) - sigma) / A(i,i);

            // Check how close the x-s we have are to a solution in this row
            real_t update = fabs ( X(i) - x_before );

            // Remember the biggest update so we can print it out
            if ( update > max_update )
            {
                max_update = update;
                update_row = i;
            }
        }

        // Count iterations and report how far we are from our goal
        iterations = iterations + 1;
        printf (
            "%le update in row %ld iteration %ld\n",
            max_update, update_row, iterations
        );
    } while ( max_update > threshold );

    /* Save the result */
    FILE *output = fopen ( "x.dat", "wb" );
    fwrite ( x_vec, sizeof(real_t), N, output );
    fclose ( output );

    /* Quit */
    free ( full_matrix );
    free ( x_vec );
    free ( b_vec );
    exit ( EXIT_SUCCESS );
}
