#include "common.h"
real_t
    *x_vec       = NULL,
    *x_prime     = NULL,
    *b_vec       = NULL;

#define X(i)  x_vec[(i)]
#define Xp(i) x_prime[(i)]
#define B(i)  b_vec[(i)]

int
main ()
{
    /* Allocate stuff for the matrix, two x-vectors (old/new), and b */
    full_matrix = malloc ( N * N * sizeof(real_t) );
    x_vec       = malloc ( N * sizeof(real_t) );
    x_prime     = malloc ( N * sizeof(real_t) );
    b_vec       = malloc ( N * sizeof(real_t) );

    /* Load the matrix */
    FILE *input = fopen ( "ex3.dat", "r" );
    fread ( full_matrix, sizeof(real_t), N*N, input );
    fclose ( input );

    /* Load the right hand side vector */
    input = fopen ( "b.dat", "r" );
    fread ( b_vec, sizeof(real_t), N, input );
    fclose ( input );

    /* Initialize the left hand side vector (x) arbitrarily */
    struct timeval now;
    gettimeofday ( &now, NULL );
    srand ( now.tv_usec );
    for ( int_t i=0; i<N; i++ )
        X(i) = rand() / (real_t) RAND_MAX;

    /* Run Jacobi iterations until x is close enough */
    int_t iterations = 0;

    int_t update_row = 0;       // Where was the biggest update this time?
    real_t
        max_update,             // What's the biggest error this time?
        threshold = 5e-8;       // Stop when it's smaller than this
    do {
        max_update = 0.0;       // New iteration, new updates to make

        for ( int_t i=0; i<N; i++ )
        {
            // Here's the Jacobi formula
            real_t sigma = 0.0;
            for ( int_t j=0; j<N; j++ )
                if ( j != i )
                    sigma = sigma + A(i,j) * X(j);
            Xp(i) = (B(i) - sigma) / A(i,i);

            // Check how big of a change we made in this row
            real_t update = fabs ( Xp(i) - X(i) );

            // Remember the biggest update so we can print it out
            if ( update > max_update )
            {
                max_update = update;
                update_row = i;
            }
        }

        // That's one step - re-use the old vector for new values
        real_t *tmp = x_vec;
        x_vec = x_prime;
        x_prime = tmp;

        // Count iterations and report how far we are from our goal
        iterations = iterations + 1;
        printf (
            "%le update in row %ld iteration %ld\n",
            max_update, update_row, iterations
        );
    } while ( max_update > threshold );

    /* Save the result */
    FILE *output = fopen ( "x.dat", "wb" );
    fwrite ( x_vec, sizeof(real_t), N, output );
    fclose ( output );

    /* Quit */
    free ( full_matrix );
    free ( x_vec );
    free ( x_prime );
    free ( b_vec );
    exit ( EXIT_SUCCESS );
}
